{
    GPS Satellite positions
                               
}
CON
  _CLKMODE = XTAL1 + PLL16X
  _XINFREQ = 5_000_000
  _stack = 48
   
  x_tiles = 16
  y_tiles = 12
 
VAR
  long nom,sat,alt,hdg,speed,dxx,dx,dy,id,no
  long sign,DecimalIndex,spacing,DecimalFlag,Digit,TempNum
  word azimuth[12],elevation[12],sid[12],snr[12]
  
  long PAL_Mode      '  these 
  long bitmap[3072]  '  must be contiguous
  
  long display[3072] ' area for graphics engine to create the display bitmap
     
OBJ
    gps        :   "GPS_IO_full"
    overlay    :   "HITT_Video_Overlay_017" 
    gr         :   "graphics_mini"
    
PUB main

    'start and setup graphics

overlay.start(@PAL_Mode)             ' start video
    
gr.start
gr.setup(x_tiles, y_tiles, 128, 96, @display)
gr.colorwidth(1, 0)                    'Set Color and Width
gr.textmode(1,1,8,0)
 
gps.start                              ' start  GPS
    
repeat                                 ' loop forever
    
  gr.clear
  gr.arc(0, 0, 90, 90, 0, 23, 360, 0)  ' draw horizon
  gr.text(-2,74, string("N"))
  gr.text(81,-8, string("E"))
  gr.text(-2,-89, string("S"))
  gr.text(-84,-8, string("W"))
  gr.plot(-4,-4)                        ' draw zenith
  gr.line(4,4)
  gr.plot(-4,4)                         ' draw zenith
  gr.line(4,-4)

  ticks(32,92)    ' draw reference vectors
  
  nom :=  atoi(gps.satellites,2)
  repeat sat from 1 to  nom
    display_satellite(sat)
     
  gr.text(-127,-70,gps.satellites)    ' display number of satellites in view
  gr.finish
  gr.text(-127,-82,gps.hdop)          ' display horizontal dilution of precision
  gr.finish 
  gr.text(96,-70,gps.vdop)      ' display vertical dilution of precision
  gr.finish
  gr.text(80, -95,gps.time)           ' display time
  gr.finish
  gr.text(-127,-95,gps.date)          ' display date
  gr.finish
'  gr.text(-42, -82,gps.longitude)    ' display longitude
'  gr.text( 42, -82,gps.E_W)
'  gr.finish 
'  gr.text(-34, -70,gps.latitude)     ' display Latitude
'  gr.text( 42, -70,gps.N_S) 
'  gr.finish    
  alt := atoi(gps.altitude,3)
  SimpleNum(120,-82,alt,-1)          '  Display Altitude  
'  gr.finish 
'  hdg :=   atoi(gps.heading,2)       '  Display Compass Heading
'  SimpleNum(104,-82,hdg,-1)              
'  gr.finish  
'  speed := atoi(gps.speed,3)      '  Display speed
'  speed := (speed * 1852) / 1000  '  Convert knots to km/h
'  speed := (speed * 6076) / 5280  '  Convert knots to miles/h
'  SimpleNum(104,-70,speed,-1)

  gr.finish
  gr.copy(@bitmap)
  
PUB display_satellite(sat_num)
   if gps.ready == 1
     dx := atoi(gps.sat_azimuth(sat_num),3)
     dy := atoi(gps.sat_elevation(sat_num),2)
     id := atoi(gps.sat_id(sat_num),2)
     no := atoi(gps.sat_snr(sat_num),2)
   else
     dx := azimuth[sat_num]
     dy := elevation[sat_num]
     id := sid[sat_num]
     no := snr[sat_num] 
   SimpleNum(64,95-sat_num*12-3,sid[sat_num],-1)
   gr.finish

   if dx > 0
      if dy > 0
        azimuth[sat_num] := dx
        elevation[sat_num] := dy     
        sid[sat_num] := id
        snr[sat_num] := no
        SimpleNum(120,95-sat_num*12-3,dx,-1)
        gr.finish         
        SimpleNum(90,95-sat_num*12-3,dy,-1)
        gr.finish       
        dx := azimuth[sat_num] 
        dy := elevation[sat_num]
        gr.colorwidth(1, 1)
        gr.arc(0, 0, 90-dy, 90-dy, -((dx * 1024)/45)+2048, 0, 1, 0)  ' display satellite spot
        gr.colorwidth(1, 0)
       
PUB atoi( pptr,c)| ptrr        ' convert c characters into number 
  result := sign := 0
  if byte[pptr] == "-"
      sign++
      pptr++
  c--    
  repeat ptrr from 0 to c
    if byte[pptr+ptrr] == 0     ' stop if null  
         quit
         
    if byte[pptr+ptrr] == "."   ' stop if decimal point
         quit
    else     
       result := result * 10 + (byte[pptr+ptrr] - "0")
  if sign == 1
    result := -result

PUB ticks(n,l)
    repeat dxx from 0 to n                   ' Draw n ticks 
        gr.arc(0, 0, l-4, l-4, dxx*8192/n, 0, 1, 0)
        gr.arc(0, 0, l, l, dxx*8192/n, 0, 1, 1)
                  
PUB SimpleNum(x,y,DecimalNumber,DecimalPoint)
    DecimalIndex := DecimalFlag := 0

    TempNum := DecimalNumber                            'Preserve sign of DecimalNumber
    DecimalNumber := ||DecimalNumber
    
    if DecimalNumber <> TempNum 
       sign := 1
    else
       sign := 0

    repeat                                              'Print digits
      if DecimalPoint > 0
        if DecimalIndex == DecimalPoint
          gr.text(x,y,@DP)                               'Insert decimal point at proper location
          x -= 8

      TempNum := DecimalNumber                          'Extract the least significant digit
      TempNum := DecimalNumber - ((TempNum / 10) * 10)

      Digit := "0" + TempNum                            'Display the least significant digit
      gr.text(x,y,@Digit)

      x -= 8
      DecimalIndex := DecimalIndex + 1
      DecimalNumber := DecimalNumber / 10               'Divide DecimalNumber by 10 

      if DecimalNumber == 0                             'Exit logic
         repeat while DecimalIndex < DecimalPoint       '   Do this if DecimalNumber is less than where the decimal point should be
            gr.text(x,y,@Zero)
            x -= 8
            DecimalIndex := DecimalIndex + 1
            DecimalFlag := 1
         if DecimalPoint > 0
            if DecimalIndex == DecimalPoint                '   Set flag if DecimalNumber is equal to where the decimal point should be  
               DecimalFlag := 1   
         if DecimalFlag == 1
            gr.text(x,y,@DP)                            '   Insert decimal and leading Zero
            x -= 8
            gr.text(x,y,@Zero)                          
            x -= 8                
         if sign == 1                                   '   Restore sign of DecimalNumber
            gr.text(x,y,@Hyphen)
         quit



DAT

Zero                    word    "0"
DP                      word    "."
Hyphen                  word    "-"        
    